/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.system;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEvent;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEventLogger;
import com.ibm.hwmca.xfw.pa.system.RemoteMachineSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemManager;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemStateEvent;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemStateListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class RemoteMachineSystemMonitor
implements RemoteSystemStateListener,
DistributedDataEventLogger {
    private static final String TRACE_MASKT = "XPARMSMT";
    private static final String TRACE_MASKF = "XPARMSMF";
    private static final String TRACE_MASKD = "XPARMSMD";
    protected RemoteSystemManager rsm = RemoteSystemManager.getRemoteSystemManager();
    protected Set systemSet = null;
    protected Object setLock = new Object();
    protected Map communicationMap = null;
    protected Map monitorCfgMap = null;
    private static final String KEY_LOG_MAP = "LogMap";
    private static final String KEY_LOG_CLASS = "LogClass";
    private static final String KEY_LOG_TYPE = "LogType";
    private static final String KEY_LOG_USER = "LogUser";
    private static final String KEY_LOG_NAME = "LogName";
    private byte logClass = 0;
    private byte logType = 0;
    private short logUser = 0;
    private String logName = "";
    public static final Class[] CLASS_SIGNATURE = new Class[]{class$java$util$Map == null ? (class$java$util$Map = RemoteMachineSystemMonitor.class$("java.util.Map")) : class$java$util$Map};
    static /* synthetic */ Class class$java$util$Map;

    public RemoteMachineSystemMonitor(Map cfgMap) {
        Trace.trace(TRACE_MASKD, "--> ctor");
        RemoteSystemManager rsm = RemoteSystemManager.getRemoteSystemManager();
        if (rsm != null) {
            rsm.addRemoteSystemStateListener(this);
        }
        this.monitorCfgMap = (Map)cfgMap.get(this.getMonitorCfgMapKey());
        if (this.monitorCfgMap == null) {
            Trace.trace(TRACE_MASKT, "monitor configuration key (" + this.getMonitorCfgMapKey() + ") not found.");
            return;
        }
        Map logMap = (Map)this.monitorCfgMap.get(KEY_LOG_MAP);
        if (logMap == null) {
            Trace.trace(TRACE_MASKT, "No log configuration key (LogMap) found for " + this.getMonitorCfgMapKey() + ".");
            return;
        }
        this.logClass = Byte.parseByte((String)logMap.get(KEY_LOG_CLASS), 16);
        this.logType = Byte.parseByte((String)logMap.get(KEY_LOG_TYPE), 16);
        this.logUser = Short.parseShort((String)logMap.get(KEY_LOG_USER), 16);
        this.logName = (String)logMap.get(KEY_LOG_NAME);
        Trace.trace(TRACE_MASKD, "class=" + Integer.toHexString(this.logClass & 0xFF));
        Trace.trace(TRACE_MASKD, "type=" + Integer.toHexString(this.logType & 0xFF));
        Trace.trace(TRACE_MASKD, "user=" + Integer.toHexString(this.logUser & 0xFFFF));
        Trace.trace(TRACE_MASKD, "name=" + this.logName);
        Trace.trace(TRACE_MASKD, "<-- ctor");
    }

    protected abstract String getMonitorCfgMapKey();

    public abstract void start();

    protected void buildCommunicationMap(Set systemSet) {
        this.communicationMap = new HashMap();
        Iterator systemIter = systemSet.iterator();
        RemoteSystem rs = null;
        while (systemIter.hasNext()) {
            rs = (RemoteSystem)systemIter.next();
            this.communicationMap.put(rs.getUniqueKey(), new Boolean(rs.canCommunicate()));
        }
    }

    protected void synchronizeSystems(Set cloneSet) {
        Trace.trace(TRACE_MASKD, "--> synchronizeSystems");
        Iterator sysIter = cloneSet.iterator();
        RemoteMachineSystem rms = null;
        while (sysIter.hasNext()) {
            rms = (RemoteMachineSystem)sysIter.next();
            if (rms.canCommunicate()) {
                Trace.trace(TRACE_MASKD, "synchronizing " + rms.getSystemName());
                rms.synchronizeSystem(this.monitorCfgMap, this);
                if (this.rsm == null) continue;
                try {
                    this.rsm.changeLiveSystem(rms);
                }
                catch (HException he) {}
                continue;
            }
            Trace.trace(TRACE_MASKD, "can't communicate/synchronize " + rms.getSystemName());
        }
        Trace.trace(TRACE_MASKD, "<-- synchronizeSystems");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteSystemStateChanged(RemoteSystemStateEvent rsStateEvent) {
        Trace.trace(TRACE_MASKD, "--> remoteSystemStateChanged");
        boolean synchSys = false;
        RemoteSystem rs = rsStateEvent.getRemoteSystem();
        Object object = this.setLock;
        synchronized (object) {
            if (this.systemSet == null) {
                return;
            }
            if (rsStateEvent.getState() == "Add") {
                Trace.trace(TRACE_MASKF, "add event");
                if (!this.systemSet.contains(rs)) {
                    this.systemSet.add(rs);
                    Trace.trace(TRACE_MASKD, "add it to the map");
                }
                Trace.trace(TRACE_MASKD, "put " + rs.getUniqueKey() + " com status =" + rs.canCommunicate());
                this.communicationMap.put(rs.getUniqueKey(), new Boolean(rs.canCommunicate()));
                synchSys = rs.canCommunicate();
            } else if (rsStateEvent.getState() == "Change") {
                Trace.trace(TRACE_MASKF, "change event");
                boolean couldCommunicate = (Boolean)this.communicationMap.get(rs.getUniqueKey());
                Trace.trace(TRACE_MASKD, "couldCommunicate is " + couldCommunicate);
                if (!couldCommunicate && rs.canCommunicate()) {
                    synchSys = true;
                    Trace.trace(TRACE_MASKF, "do a resync");
                }
                this.communicationMap.put(rs.getUniqueKey(), new Boolean(rs.canCommunicate()));
            } else if (rsStateEvent.getState() == "Remove") {
                Trace.trace(TRACE_MASKF, "remove event");
                this.systemSet.remove(rs);
                this.communicationMap.remove(rs.getUniqueKey());
            }
        }
        if (synchSys) {
            Trace.trace(TRACE_MASKD, "synchronizing " + rs.getSystemName());
            rs.synchronizeSystem(this.monitorCfgMap, this);
            if (this.rsm != null) {
                try {
                    this.rsm.changeLiveSystem(rs);
                }
                catch (HException he) {
                    // empty catch block
                }
            }
        }
        Trace.trace(TRACE_MASKD, "<-- remoteSystemStateChanged");
    }

    public void log(Object data, Object source, LogAttributes logAttributes) {
        Trace.trace(TRACE_MASKD, "--> log");
        Log theLog = new Log(this.logClass, this.logType, this.logUser, this.logName, null, null, null, null);
        theLog.add((byte)3, data);
        if (source instanceof RemoteMachineSystem) {
            StringBuffer sb = new StringBuffer();
            XMLHelper.outToXML(source, sb, source.getClass());
            theLog.add((byte)4, sb.toString());
        } else {
            theLog.add((byte)4, source);
        }
        theLog.log(logAttributes);
        Trace.trace(TRACE_MASKD, "<-- log");
    }

    public void log(DistributedDataEvent event) {
        if (event.isError()) {
            Trace.trace(TRACE_MASKD, "Error Event - logging for analysis");
            this.log(event.getData(), event.getSystem(), LogAttributes.ERROR_LOG);
        } else {
            Trace.trace(TRACE_MASKD, "Informational Event - logging only");
            this.log(event.getData(), event.getSystem(), LogAttributes.INFO_LOG);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

